/******************************************************************************
 * Public header file for Interrupt.
 * 
 * Freescale Semiconductor Inc.
 * (c) Copyright 2004-2011 Freescale Semiconductor, Inc.
 * ALL RIGHTS RESERVED.
 *
*******************************************************************************
 *
 * THIS SOFTWARE IS PROVIDED BY FREESCALE "AS IS" AND ANY EXPRESSED OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  
 * IN NO EVENT SHALL FREESCALE OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, 
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES 
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, 
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING 
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF 
 * THE POSSIBILITY OF SUCH DAMAGE.
 *
***************************************************************************//*!
******************************************************************************/

#ifndef INTERRUPT_H_
#define INTERRUPT_H_


/******************************************************************************
*******************************************************************************
* Includes
*******************************************************************************
******************************************************************************/

#include "EmbeddedTypes.h"





/******************************************************************************
*******************************************************************************
* Private macros
*******************************************************************************
******************************************************************************/

/*ARM Cortex M4 implementation for interrupt priority shift*/
#define ARM_INTERRUPT_LEVEL_BITS          2

/* Maximum IRQ value (check Kinetis manual) */
#define ARM_MAX_IRQ_VALUE		91
/* Maximum value for IRQ priority (Kinetis uses 4 bits - check the manual) */
#define ARM_MAX_PRIO_VALUE		15


/*****************************************************************************
******************************************************************************
* Global Functions Prototypes
******************************************************************************
*****************************************************************************/

/************************************************************************************
* Primitives to enable/disable all processor interrupts.
* Through immediate access and no backup handles the state of the interrupt mask bit 
* in the status register.
* 
*   
* Interface assumptions:
*   None
*   
* Return value:
*   None
* 
************************************************************************************/
/*!< Macro to enable all interrupts. */
#define EnableInterrupts() asm(" CPSIE i");

  /*!< Macro to disable all interrupts. */
#define DisableInterrupts() asm(" CPSID i");

#if defined (IAR)
#define IntEnableAll()         IntRestoreAll(0)
#endif
	

/******************************************************************************
 * Name: Stop
 * Description: 
 *****************************************************************************/

void Stop (void);

/******************************************************************************
 * Name: Wait
 * Description: 
 *****************************************************************************/
void Wait (void);

/******************************************************************************
 * Name: write_vtor
 * Description: 
 *****************************************************************************/

void write_vtor (int);

/******************************************************************************
 * Name: NVIC_EnableIRQ
 * Description: Enable a single IRQ
 *****************************************************************************/
void NVIC_EnableIRQ (int);

/******************************************************************************
 * Name: NVIC_Disable_Irq
 * Description: Disable a single IRQ
 *****************************************************************************/
void NVIC_Disable_Irq (int);

/******************************************************************************
 * Name: NVIC_SetPriority
 * Description: Set the priority for  a single IRQ
 ************************************************************************/

void NVIC_SetPriority (int, int);

#if defined (IAR)
extern void IntRestoreAll(unsigned int if_bits);
extern unsigned int IntDisableAll(void);
#elif  defined (CW)
extern void IntDisableAll(uint32_t var);
extern void IntRestoreAll(uint32_t var1);
#endif

/******************************************************************************
 * Vector Definitions
 ************************************************************************/


#undef VECTOR_028
#define VECTOR_028 		Uart0InterruptHandler
extern void Uart0InterruptHandler(void);

#undef VECTOR_033
#define VECTOR_033 		TMR_InterruptHandler
extern void TMR_InterruptHandler (void);

#undef  VECTOR_035
#define VECTOR_035 		PhyTime_ISR 
extern void PhyTime_ISR(void);					

#if gKeyboardSupported==TRUE

#undef VECTOR_046
#define VECTOR_046              Keyboard1_Interrupt
extern void Keyboard1_Interrupt (void);

#undef VECTOR_047
#define VECTOR_047              Keyboard2_Interrupt
extern void Keyboard2_Interrupt (void);
#else

#undef  VECTOR_047
#define VECTOR_047 		Phy_ISR 
extern void Phy_ISR(void);						

#endif

#endif /* INTERRUPT_H_ */
